#ifndef AHLGREN_GLOBAL
#define AHLGREN_GLOBAL

#define BOOST_RESULT_OF_USE_DECLTYPE
#include <boost/filesystem.hpp>
#include <boost/range/adaptor/map.hpp>

// Type for Execution Time Limits
#include <chrono>
typedef std::chrono::steady_clock::time_point deadline_t;
struct time_out : public std::exception {};

// Hard Coded Program Values
#define PROG_VERSION "3.9"
#define PROG_NAME "Atom"
#define AUTHOR_EMAIL "ahlgren@gmail.com"


#ifdef _WIN32
#define IS_WINDOWS 1
//#include <Windows.h>
const char switch_char = '/';
#else
#define IS_WINDOWS 0
const char switch_char = '-';
#endif


#include "functor_tbl.h" // int typedef
namespace lp {
	extern functor_map fmap;
	class Dictionary;
	extern Dictionary prolog_dic;
}

extern boost::filesystem::path PATH_TO_PROGRAM;

// =============== Debugging Macros =============== //

namespace debug_type {
	enum { nothing=0, crucial=1, warning=2, basic=3, info=4, trace=5 };
}

// Debugging verbosity level: defaults to printing only warning in release, and trace in debug
extern lp::data verbosity;
extern lp::data pretty_print;

#define DEBUG_CRUCIAL(fun) do { if (verbosity.is_int() && verbosity.get_int() >= debug_type::crucial) { fun ; } } while (0)
#define DEBUG_WARNING(fun) do { if (verbosity.is_int() && verbosity.get_int() >= debug_type::warning) { fun ; } } while (0)
#define DEBUG_BASIC(fun) do { if (verbosity.is_int() && verbosity.get_int() >= debug_type::basic) { fun ; } } while (0)
#define DEBUG_INFO(fun) do { if (verbosity.is_int() && verbosity.get_int() >= debug_type::info) { fun ; } } while (0)

#ifdef NDEBUG
// Release mode, optimizes away trace code
#define DEBUG_TRACE(fun)
#else
// Debug mode
#define DEBUG_TRACE(fun) do { if (verbosity.is_int() && verbosity.get_int() >= debug_type::trace) { fun ; } } while (0)
#endif

// Class thrown by halt/0 to exit program with destructor calls
struct destruct_and_exit {};

// Bit String Type Definition
#include <vector>
#include <iostream>
namespace lp {
	typedef int bit_t;
	typedef std::vector<bit_t> bitstring;
	inline std::ostream& operator<<(std::ostream& os, const bitstring& b) { for (auto i : b) os << i; return os; }
}

// =============== Random Number Generator =============== //
#include <random>

typedef std::mt19937 rng_type;  // use Mersenne Twister
extern rng_type rng;


#endif
